/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import com.google.common.base.Preconditions;
import org.bukkit.block.Block;
import org.bukkit.event.block.InventoryBlockStartEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.Experimental
public class BrewingStartEvent
extends InventoryBlockStartEvent {
    private int brewingTime;
    private int recipeBrewTime = 400;

    @ApiStatus.Internal
    public BrewingStartEvent(@NotNull Block brewingStand, @NotNull ItemStack source, int brewingTime) {
        super(brewingStand, source);
        this.brewingTime = brewingTime;
    }

    @Deprecated(since="1.21", forRemoval=true)
    public int getTotalBrewTime() {
        return this.brewingTime;
    }

    @Deprecated(since="1.21", forRemoval=true)
    public void setTotalBrewTime(int brewTime) {
        this.setBrewingTime(brewTime);
    }

    @ApiStatus.Experimental
    public @Range(from=1L, to=0x7FFFFFFFL) int getRecipeBrewTime() {
        return this.recipeBrewTime;
    }

    @ApiStatus.Experimental
    public void setRecipeBrewTime(@Range(from=1L, to=0x7FFFFFFFL) int recipeBrewTime) {
        Preconditions.checkArgument((recipeBrewTime > 0 ? 1 : 0) != 0, (Object)"recipeBrewTime must be positive");
        this.recipeBrewTime = recipeBrewTime;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getBrewingTime() {
        return this.brewingTime;
    }

    public void setBrewingTime(@Range(from=0L, to=0x7FFFFFFFL) int brewTime) {
        Preconditions.checkArgument((brewTime >= 0 ? 1 : 0) != 0, (Object)"brewTime must be non-negative");
        this.brewingTime = brewTime;
    }
}

