/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block.banner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.registry.RegistryKey;
import java.util.Map;
import java.util.NoSuchElementException;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="Pattern")
public class Pattern
implements ConfigurationSerializable {
    private static final String COLOR = "color";
    private static final String PATTERN = "pattern";
    private final DyeColor color;
    private final PatternType pattern;

    public Pattern(@NotNull DyeColor color, @NotNull PatternType pattern) {
        this.color = color;
        this.pattern = pattern;
    }

    public Pattern(@NotNull Map<String, Object> map) {
        this.color = DyeColor.legacyValueOf(Pattern.getString(map, COLOR));
        String value = Pattern.getString(map, PATTERN);
        PatternType patternType = PatternType.getByIdentifier(value);
        if (patternType == null) {
            patternType = Bukkit.getUnsafe().get(RegistryKey.BANNER_PATTERN, NamespacedKey.fromString(value));
        }
        Preconditions.checkNotNull((Object)patternType, (String)"Pattern type for key %s cannot be null", (Object)value);
        this.pattern = patternType;
    }

    private static String getString(@NotNull Map<?, ?> map, @NotNull Object key) {
        Object str = map.get(key);
        if (str instanceof String) {
            return (String)str;
        }
        throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(key));
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        return ImmutableMap.of((Object)COLOR, (Object)this.color.toString(), (Object)PATTERN, (Object)this.pattern.getKey().toString());
    }

    @NotNull
    public DyeColor getColor() {
        return this.color;
    }

    @NotNull
    public PatternType getPattern() {
        return this.pattern;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.color != null ? this.color.hashCode() : 0);
        hash = 97 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pattern other = (Pattern)obj;
        return this.color == other.color && this.pattern == other.pattern;
    }
}

