/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.loader.library.impl;

import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.LibraryLoadingException;
import io.papermc.paper.plugin.loader.library.LibraryStore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class MavenLibraryResolver
implements ClassPathLibrary {
    public static final String MAVEN_CENTRAL_DEFAULT_MIRROR = MavenLibraryResolver.getDefaultMavenCentralMirror();
    private static final List<String> MAVEN_CENTRAL_URLS = List.of("https://repo1.maven.org/maven2", "http://repo1.maven.org/maven2", "https://repo.maven.apache.org/maven2", "http://repo.maven.apache.org/maven2");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MavenLibraryResolver");
    private final RepositorySystem repository;
    private final DefaultRepositorySystemSession session;
    private final List<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();

    public MavenLibraryResolver() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.repository = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.session = MavenRepositorySystemUtils.newSession();
        this.session.setSystemProperties((Map)System.getProperties());
        this.session.setChecksumPolicy("fail");
        this.session.setLocalRepositoryManager(this.repository.newLocalRepositoryManager((RepositorySystemSession)this.session, new LocalRepository("libraries")));
        this.session.setTransferListener((TransferListener)new AbstractTransferListener(this){

            public void transferInitiated(TransferEvent event) throws TransferCancelledException {
                LOGGER.info("Downloading {}", (Object)(event.getResource().getRepositoryUrl() + event.getResource().getResourceName()));
            }
        });
        this.session.setReadOnly();
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addRepository(RemoteRepository remoteRepository) {
        if (MAVEN_CENTRAL_URLS.stream().anyMatch(remoteRepository.getUrl()::startsWith)) {
            LOGGER.warn("Use of Maven Central as a CDN is against the Maven Central Terms of Service. Use MavenLibraryResolver.MAVEN_CENTRAL_DEFAULT_MIRROR instead.", (Throwable)new RuntimeException("Plugin used Maven Central for library resolution (%s)".formatted(remoteRepository.toString())));
        }
        this.repositories.add(remoteRepository);
    }

    @Override
    public void register(LibraryStore store) throws LibraryLoadingException {
        DependencyResult result;
        List repos = this.repository.newResolutionRepositories((RepositorySystemSession)this.session, this.repositories);
        try {
            result = this.repository.resolveDependencies((RepositorySystemSession)this.session, new DependencyRequest(new CollectRequest((Dependency)null, this.dependencies, repos), null));
        }
        catch (DependencyResolutionException ex) {
            throw new LibraryLoadingException("Error resolving libraries", (Exception)((Object)ex));
        }
        for (ArtifactResult artifact : result.getArtifactResults()) {
            File file = artifact.getArtifact().getFile();
            store.addLibrary(file.toPath());
        }
    }

    private static String getDefaultMavenCentralMirror() {
        String central = System.getenv("PAPER_DEFAULT_CENTRAL_REPOSITORY");
        if (central == null) {
            central = System.getProperty("org.bukkit.plugin.java.LibraryLoader.centralURL");
        }
        if (central == null) {
            central = "https://maven-central.storage-download.googleapis.com/maven2";
        }
        return central;
    }
}

